/************************************************************************
* (c) Copyright Freescale Semiconductor, Inc 2010, All Rights Reserved  *
*************************************************************************

************************************************************************
*                                                                      *
*        Standard Software Flash Driver For FTFL           		         *
*                                                                      *
* FILE NAME     :  DEFlashPartition.c                                  *
* DATE          :  June 11,2010                                        *
*                                                                      *
* AUTHOR        :  FPT Team                                            *
* E-mail        :  b28216@freescale.com                                *
*                                                                      *
************************************************************************/

/************************** CHANGES ***********************************
0.0.1    	06.09.2010    	FPT Team            		Initial Version
0.1.0    	06.11.2010    	FPT Team            		Finalize to 0.1.0 
***********************************************************************/

/* include the header files */
#include "SSD_Types.h"
#include "SSD_FTFL.h"
#include "SSD_FTFL_Internal.h"


/************************************************************************
*
*  Function Name    : DEFlashPartition.c
*  Description      : This function  prepares the D/E-Flash block for use
*					            as D-Flash, E-Flash or a combination of both and 
*					            initializes the EERAM.
*  Arguments        : PFLASH_SSD_CONFIG, UINT8,UINT8, pFLASHCOMMANDSEQUENCE
*  Return Value     : UINT32
*
*************************************************************************/

UINT32 DEFlashPartition(PFLASH_SSD_CONFIG PSSDConfig, \
												UINT8 EEEDataSizeCode, \
												UINT8 DEPartitionCode, \
												pFLASHCOMMANDSEQUENCE FlashCommandSequence)
{
    UINT8 pCommandArray[6]; /* command sequence array */
    UINT32 returnCode;      /* return code variable */

    /* set the default return code as FTFL_OK */
    returnCode = FTFL_OK;
	
	  /* preparing passing parameter to program partition command */
    pCommandArray[0] = FTFL_PROGRAM_PARTITION;
	  pCommandArray[4] = EEEDataSizeCode;
	  pCommandArray[5] = DEPartitionCode;

    /* calling flash command sequence function to execute the command */
    returnCode = FlashCommandSequence(PSSDConfig, 5, pCommandArray);

    /* Enter Debug state if enabled */
    if (TRUE == (PSSDConfig->DebugEnable))
    {
         asm
         (
          debughlt           /* enter Debug state */
         );
    }

    return(returnCode);
}
/* end of file */